@extends('layouts.admin')

@section('title', 'Forum Boards')

@section('content')
<div class="users-management">
    <div class="users-header">
        <h2>Forum Boards</h2>
        <div class="users-actions">
            <a href="{{ route('admin.forum.boards.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Board
            </a>
        </div>
    </div>
    
    <div class="dashboard-card dashboard-card-full">
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Threads</th>
                            <th>Access</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($boards as $board)
                        <tr>
                            <td>{{ $board->order }}</td>
                            <td>
                                {{ $board->name }}
                                @if(!$board->is_public)
                                    <span class="forum-access-badge forum-access-badge--restricted">
                                        RESTRICTED
                                    </span>
                                @endif
                            </td>
                            <td>
                                {{ $board->category->name }}
                                @if(!$board->category->is_public)
                                    <span class="forum-access-badge forum-access-badge--category-restricted">
                                        CAT-RESTRICTED
                                    </span>
                                @endif
                            </td>
                            <td>{{ $board->threads->count() }}</td>
                            <td>
                                @if($board->is_public && $board->category->is_public)
                                    <span class="user-role role-user">Public</span>
                                @else
                                    <div class="forum-access-info">
                                        @if(!$board->category->is_public)
                                            <div class="forum-access-info__inheritance">
                                                Inherits Category Restrictions
                                            </div>
                                        @endif
                                        @if(!$board->is_public)
                                            @if($board->required_roles)
                                                <div class="forum-access-info__item">
                                                    <strong>Roles:</strong> {{ implode(', ', $board->required_roles) }}
                                                </div>
                                            @endif
                                            @if($board->required_permissions)
                                                <div class="forum-access-info__item">
                                                    <strong>Perms:</strong> {{ implode(', ', $board->required_permissions) }}
                                                </div>
                                            @endif
                                        @endif
                                    </div>
                                @endif
                            </td>
                            <td>
                                <span class="user-role {{ $board->is_active ? 'role-moderator' : 'role-user' }}">
                                    {{ $board->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td class="user-actions">
                                <a href="{{ route('admin.forum.boards.edit', $board) }}" class="btn-icon" title="Edit Board">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.forum.boards.destroy', $board) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn-icon btn-danger" title="Delete Board" onclick="return confirm('Are you sure you want to delete this board? This will also delete all threads within it.')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center">No boards found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Access Control Legend --}}
            <div class="forum-access-legend">
                <h6 class="forum-access-legend__title">
                    <i class="fas fa-info-circle"></i> Access Control Legend
                </h6>
                <div class="forum-access-legend__content">
                    <div class="forum-access-legend__item">
                        <strong>Public:</strong> Accessible by all users (including guests)
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Restricted boards</strong> are marked with a red badge
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>CAT-RESTRICTED:</strong> Category has access restrictions
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Roles:</strong> User must have at least ONE of the listed roles
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Perms:</strong> User must have ALL of the listed permissions
                    </div>
                    <div class="forum-access-legend__notice">
                        <strong>Note:</strong> Boards inherit category restrictions. If a category is restricted, all its boards require category access plus any additional board restrictions.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection